package mcfall.raytracer.objects;

import java.util.ArrayList;
import java.util.List;

import mcfall.math.NotInvertibleException;
import mcfall.math.Point;
import mcfall.math.Ray;
import mcfall.math.Vector;

/**
 * The Class GenericCube creates a 2x2 cube centered at (0,0,0)
 */
public class GenericCube extends MathematicalObject { 
	private static final int X=1,Y=2,Z=3;
	/**
	 * Instantiates a new generic cube.
	 */
	public GenericCube () {
		super ();
	}
	
	/**
	 * Constructs a GenericCubeobject with the given name.
	 * 
	 * @param name the name to associate with this object
	 */
	public GenericCube (String name) {
		super(name);
	}
	/* (non-Javadoc)
	 * @see mcfall.raytracer.objects.MathematicalObject#genericHitTime(mcfall.raytracer.Ray)
	 */
	@Override
	protected List<HitRecord> genericHitTime(Ray ray) {
		return new java.util.ArrayList<HitRecord> ();
	}
	protected Vector computeNormal(int surf) {
		switch(surf){
			case(0): return new Point(0,1,0);
			case(1): return new Point(0,-1,0);
			case(2): return new Point(1,0,0);
			case(3): return new Point(-1,0,0);
			case(4): return new Point(0,0,1);
			case(5): return new Point(0,0,-1);
		}
		return null;//souldn't ever get here but makes java happy
	}
	/* (non-Javadoc)
	 * @see mcfall.raytracer.objects.MathematicalObject#getObjectType()
	 */
	@Override
	protected String getObjectType() {
		return "Generic Cube";
	}
	

}
